SELECT s.name AS TABLE_SCHEMA, o.name AS TABLE_NAME,
       CASE o."type" WHEN 'V' THEN 'VIEW' ELSE 'TABLE' END AS TABLE_TYPE,
       st.name AS STAT_NAME,
       STATS_DATE(st.object_id, st.stats_id) AS STATS_DATE,
       CASE WHEN index_id IS NULL THEN 'colonne' ELSE 'index' END AS NATURE,
       CASE WHEN user_created = 1 THEN 'USER'
            WHEN auto_created = 1 THEN 'AUTO' 
			ELSE 'INDEX' 
	   END AS CREATE_BY,
       no_recompute, COALESCE(st.filter_definition, '<NO>') AS filtered,
       is_temporary
FROM   sys.stats AS st
       INNER JOIN sys.objects AS o
             ON st.object_id = o.object_id
       INNER JOIN sys.schemas AS s
             ON o.schema_id = s.schema_id
       LEFT OUTER JOIN sys.indexes AS i
             ON st.object_id = i.object_id
                AND st.name = i.name;

--> NOTA : 
--  1) la version 2005 ne connait pas les statistiques filtres. Vous devez supprimer toute rfrence  "filter_definition"
--  2) les versions infrieures  2012 ne connaissent pas les statistiques temporaires. Vous devez supprimer toute rfrence  "is_temporary"